<?php
/**
 * Plugin Name:       افزونه فروش گیفت سیتی برای ووکامرس
 * Plugin URI:        https://gift30t.com/api-docs/wordpress-plugin
 * Description:       اتصال مستقیم ووکامرس به API گیفت سیتی برای فروش استارز تلگرام و سایر محصولات با سنک خودکار قیمت و موجودی.
 * Version:           1.0.0
 * Requires at least: 6.2
 * Requires PHP:      7.4
 * Requires Plugins:  woocommerce
 * Author:            mrdejam
 * Author URI:        https://www.instagram.com/mrdejam
 * Text Domain:       giftcity-wc
 * Domain Path:       /languages
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!defined('GIFTCITY_WC_VERSION')) {
    define('GIFTCITY_WC_VERSION', '1.0.0');
}

function autoload_giftcity_wc_files(): void
{
    require_once GIFTCITY_WC_PLUGIN_DIR . 'includes/helpers.php';
    require_once GIFTCITY_WC_PLUGIN_DIR . 'includes/class-client.php';
    require_once GIFTCITY_WC_PLUGIN_DIR . 'includes/class-settings.php';
    require_once GIFTCITY_WC_PLUGIN_DIR . 'includes/class-sync-service.php';
    require_once GIFTCITY_WC_PLUGIN_DIR . 'includes/class-order-service.php';
    require_once GIFTCITY_WC_PLUGIN_DIR . 'includes/class-plugin.php';
}

define('GIFTCITY_WC_PLUGIN_FILE', __FILE__);
define('GIFTCITY_WC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('GIFTCITY_WC_PLUGIN_URL', plugin_dir_url(__FILE__));

autoload_giftcity_wc_files();

GiftCity\WooCommerce\Plugin::instance();

register_activation_hook(__FILE__, ['GiftCity\\WooCommerce\\Plugin', 'activate']);
register_deactivation_hook(__FILE__, ['GiftCity\\WooCommerce\\Plugin', 'deactivate']);
